package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.biz.Task;
import gov.va.vinci.dart.biz.TaskAging;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestPersonTaskDAO  extends BusinessIntegrationTest {
	
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testTwo() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findByName("DNS");
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);
		
		try {
			PersonTask.create(null, null, pers, "testing", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), null, "testing", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, null, "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, "", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, "1234567890123456789012345678901234567890123456789012345678901234567890", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing",null);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","123456789012345678901234567890123456789012345678901234567890");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		Assert.assertTrue(task.getId() > 0);
		
		// test if we can find that task again
		Task task2 = DartObjectFactory.getInstance().getPersonTaskDAO().findById(task.getId());
		Assert.assertNotNull(task2);
	}


	@Test
	public void testThree() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		List<PersonTask> tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listByOwner(pers.getId());
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		boolean foundit = false;
		for (Task tt : tlist) {
			if (tt != null && tt.getId() == task.getId()) {
				foundit = true;
			}
		}
		
		Assert.assertTrue(foundit);
	}

	@Test
	public void testSix() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		List<PersonTask> tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listOpenByOwner(pers.getId());
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		Assert.assertTrue(tlist.contains(task));
	}

	@Test
	public void testSeven() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		List<PersonTask> tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		int requestId = rs.getFirstRequest().getId();
		Assert.assertTrue(requestId > 0);
		
		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getPersonTaskDAO().listOpenByRequestId(requestId);
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		Assert.assertTrue(tlist.contains(task));
	}

	@Test
	public void testFour() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		// create a task to assure there is something in the 0-10 day aging bucket
		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);

		TaskAging tab = DartObjectFactory.getInstance().getPersonTaskDAO().getTaskAging(pers.getId());
		Assert.assertNotNull(tab);
		Assert.assertTrue(tab.getDay0() > 0);
	}
	

	@Test
	public void testFive() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		// create a task to assure there is something in the 0-10 day aging bucket
		PersonTask task = PersonTask.create(null, rs.getFirstRequest(), pers, "testing", "testing","DNS");
		Assert.assertNotNull(task);

		Task task2 = DartObjectFactory.getInstance().getPersonTaskDAO().findById(task.getId());
		Assert.assertNotNull(task2);
		
		task.complete("DNS");
		
		Task task3 = DartObjectFactory.getInstance().getPersonTaskDAO().findById(task.getId());
		Assert.assertNotNull(task3);
		
		// shouldn't find the task after it's complete
		List<PersonTask> completed = DartObjectFactory.getInstance().getPersonTaskDAO().listAllOpenPersonTasks();
		Assert.assertNotNull(completed);
		Assert.assertFalse(completed.contains(task3));
		
		// but it still exists in the complete list
		List<PersonTask> taskList = DartObjectFactory.getInstance().getPersonTaskDAO().listAllPersonTasks();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.contains(task3));

	}

}
